<?php
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}
require_once __DIR__ . '/../../config/conexion.php';

if (!defined('BASE_URL')) {
  define('BASE_URL', '/almacencrm/');
}

// color celeste (Bootstrap primary)
$barColor = '#0d6efd';
?>
<nav class="main-header navbar navbar-expand" style="background-color: <?= $barColor ?>; color: #fff;">
  <!-- Izquierda: botn hamburguesa + marca -->
  <ul class="navbar-nav">
    <li class="nav-item">
      <a class="nav-link text-white" data-widget="pushmenu" href="#" role="button" title="Mostrar/Ocultar men">
        <i class="fas fa-bars"></i>
      </a>
    </li>
    <li class="nav-item d-none d-sm-inline-block ml-2">
      <span class="navbar-brand mb-0 h5 text-white">ENPEX</span>
    </li>
  </ul>

  <!-- Derecha: botn instalar + fecha + fullscreen -->
  <ul class="navbar-nav ml-auto align-items-center">

    <!-- Botn Instalar APP (PWA) -->
    <li class="nav-item mr-2">
      <button id="btnInstallPWA" class="btn btn-warning btn-sm" style="display:none; color:#0b3b66; font-weight:600;">
        <i class="fas fa-download mr-1"></i> Instalar app
      </button>
    </li>

    <li class="nav-item d-none d-md-inline">
      <span class="nav-link text-white">
        <i class="far fa-calendar-alt mr-1"></i><?= date('d/m/Y'); ?>
      </span>
    </li>

    <li class="nav-item">
      <a class="nav-link text-white" data-widget="fullscreen" href="#" role="button" title="Pantalla completa">
        <i class="fas fa-expand-arrows-alt"></i>
      </a>
    </li>
  </ul>
</nav>

<script>
(function(){
  const btn = document.getElementById('btnInstallPWA');

  function showIfAvailable(){
    if (window.__deferredPrompt && btn) btn.style.display = 'inline-block';
  }
  window.addEventListener('app-install-available', showIfAvailable);
  document.addEventListener('visibilitychange', showIfAvailable);
  showIfAvailable();

  btn?.addEventListener('click', async () => {
    try {
      const ev = window.__deferredPrompt;
      if (!ev) return;
      ev.prompt();
      await ev.userChoice;
      window.__deferredPrompt = null;
      btn.style.display = 'none';
    } catch (e) {}
  });
})();
</script>
