<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require_once __DIR__ . '/../../config/conexion.php';

/* BASE_URL consistente */
if (!defined('BASE_URL')) {
    define('BASE_URL', '/almacencrm/');
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>ENPEX | Almacn CRM</title>
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

  <!-- Favicon -->
  <link rel="icon" href="<?= BASE_URL ?>assets/adminlte/img/enpex_logo.png">

  <!-- ====== PWA ====== -->
  <link rel="manifest" href="<?= BASE_URL ?>manifest.webmanifest">
  <meta name="theme-color" content="#0d6efd">

  <!-- iOS -->
  <link rel="apple-touch-icon" sizes="192x192" href="<?= BASE_URL ?>icons/icon-192.png">
  <link rel="apple-touch-icon" sizes="512x512" href="<?= BASE_URL ?>icons/icon-512.png">
  <meta name="apple-mobile-web-app-capable" content="yes">
  <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">

  <script>
    // Evento de instalacin PWA (navbar puede escuchar esto)
    window.__deferredPrompt = null;
    window.addEventListener('beforeinstallprompt', (e) => {
      e.preventDefault();
      window.__deferredPrompt = e;
      window.dispatchEvent(new Event('app-install-available'));
    });
    window.addEventListener('appinstalled', () => { window.__deferredPrompt = null; });

    // ===== Service Worker (scope: /almacencrm/) =====
    (function registerSW() {
      if (!('serviceWorker' in navigator)) return;

      // versin para forzar actualizaciones del SW cuando cambie
      const SW_VERSION = '6';   // <-- si editas sw.js, incrementa este nmero
      const SW_URL = '<?= BASE_URL ?>sw.js?v=' + SW_VERSION;
      const SW_SCOPE = '<?= BASE_URL ?>';

      // Registrar/actualizar siempre bajo el scope correcto
      window.addEventListener('load', function () {
        navigator.serviceWorker.getRegistration(SW_SCOPE).then((reg) => {
          if (!reg) {
            navigator.serviceWorker.register(SW_URL, { scope: SW_SCOPE }).catch(console.error);
            return;
          }
          reg.update(); // fuerza buscar nueva versin
        });

        // Si el SW controlador cambia (por update), recarga una sola vez
        let refreshing = false;
        navigator.serviceWorker.addEventListener('controllerchange', () => {
          if (refreshing) return;
          refreshing = true;
          window.location.reload();
        });
      });
    })();
  </script>
  <!-- ===== /PWA ===== -->

  <!-- Estilos principales -->
  <link rel="stylesheet" href="<?= BASE_URL ?>assets/adminlte/plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="<?= BASE_URL ?>assets/adminlte/plugins/overlayScrollbars/css/OverlayScrollbars.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="<?= BASE_URL ?>assets/adminlte/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="<?= BASE_URL ?>assets/adminlte/css/custom-style.css?v=<?= time() ?>">

  <!-- DataTables -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap4.min.css">
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">
