<?php
require_once __DIR__ . '/../templates/header.php';
require_once __DIR__ . '/../templates/navbar.php';   //  nuevo
require_once __DIR__ . '/../templates/sidebar.php';
require_once "../../config/conexion.php";

// Verifica permisos
$puedeEliminar = in_array($_SESSION['rol'], ['Administrador', 'Supervisor']);
$puedeEditar = in_array($_SESSION['rol'], ['Administrador', 'Supervisor', 'Registrador y Reportes']);
?>

<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <h2 class="mb-4">Gestión de Usuarios</h2>
      <?php if ($puedeEditar): ?>
      <button class="btn btn-primary mb-3" data-toggle="modal" data-target="#modalUsuario">
        <i class="fas fa-user-plus"></i> Nuevo Usuario
      </button>
      <?php endif; ?>
    </div>
  </div>

  <section class="content">
    <div class="container-fluid">
      <div class="card">
        <div class="card-body">
          <table id="tablaUsuarios" class="table table-bordered table-striped">
            <thead class="thead-dark">
              <tr>
                <th>#</th>
                <th>Nombre</th>
                <th>Usuario</th>
                <th>Rol</th>
                <th>Email</th>
                <th>Estado</th>
                <?php if ($puedeEditar || $puedeEliminar): ?><th>Acciones</th><?php endif; ?>
              </tr>
            </thead>
            <tbody></tbody>
          </table>
        </div>
      </div>
    </div>
  </section>
</div>

<!-- Modal Registro/Edición -->
<div class="modal fade" id="modalUsuario" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <form id="formUsuario">
        <div class="modal-header bg-primary text-white">
          <h5 class="modal-title">Registrar Usuario</h5>
          <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="id" id="id">
          <div class="form-group">
            <label>Nombre</label>
            <input type="text" name="nombre" id="nombre" class="form-control" required>
          </div>
          <div class="form-group">
            <label>Usuario</label>
            <input type="text" name="usuario" id="usuario" class="form-control" required>
          </div>
          <div class="form-group">
            <label>Contraseña</label>
            <input type="password" name="password" id="password" class="form-control">
          </div>
          <div class="form-group">
            <label>Email</label>
            <input type="email" name="email" id="email" class="form-control">
          </div>
          <div class="form-group">
            <label>Rol</label>
            <select name="rol" id="rol" class="form-control" required>
              <option value="">-- Seleccionar --</option>
              <option value="Administrador">Administrador</option>
              <option value="Supervisor">Supervisor</option>
              <option value="Registrador y Reportes">Registrador y Reportes</option>
            </select>
          </div>
          <div class="form-group">
            <label>Estado</label>
            <select name="estado" id="estado" class="form-control">
              <option value="1">Activo</option>
              <option value="0">Inactivo</option>
            </select>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-success">Guardar</button>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
        </div>
      </form>
    </div>
  </div>
</div>

<?php require_once "../templates/footer.php"; ?>
<script src="<?= BASE_URL ?>assets/js/usuarios.js"></script>
