<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../templates/header.php';
require_once __DIR__ . '/../templates/navbar.php';   //  nuevo
require_once __DIR__ . '/../templates/sidebar.php';
require_once __DIR__ . '/../../config/conexion.php';

// Verificar sesión
if (!isset($_SESSION['usuario_id'])) {
    header("Location: ../../login.php");
    exit();
}
?>

<div class="content-wrapper">
  <section class="content-header d-flex justify-content-between align-items-center">
    <h3>Gestión de Trabajadores</h3>
    <button class="btn btn-primary" data-toggle="modal" data-target="#modalTrabajador">+ Nuevo Trabajador</button>
  </section>

  <section class="content">
    <div class="container-fluid mt-3">
      <div class="card card-outline card-info">
        <div class="card-body">
          <table id="tablaTrabajadores" class="table table-bordered table-hover">
            <thead class="thead-dark">
              <tr>
                <th>Nombre</th>
                <th>DNI</th>
                <th>Teléfono</th>
                <th>Correo</th>
                <th>Cargo</th>
                <th>Fecha Registro</th>
                <th>Acciones</th>
              </tr>
            </thead>
            <tbody>
              <!-- Se carga por JS -->
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </section>
</div>

<!-- Modal: Registrar trabajador -->
<div class="modal fade" id="modalTrabajador" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <form id="formTrabajador" class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">Registrar Trabajador</h5>
        <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body row">
        <div class="form-group col-md-6">
          <label>Nombre completo:</label>
          <input type="text" name="nombre" class="form-control" required>
        </div>
        <div class="form-group col-md-6">
          <label>DNI:</label>
          <input type="text" name="dni" class="form-control" required>
        </div>
        <div class="form-group col-md-6">
          <label>Teléfono:</label>
          <input type="text" name="telefono" class="form-control">
        </div>
        <div class="form-group col-md-6">
          <label>Correo:</label>
          <input type="email" name="correo" class="form-control">
        </div>
        <div class="form-group col-md-6">
          <label>Cargo:</label>
          <input type="text" name="cargo" class="form-control">
        </div>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-success">Guardar</button>
      </div>
    </form>
  </div>
</div>

<?php require_once __DIR__ . '/../templates/footer.php'; ?>
<script src="<?= BASE_URL ?>assets/js/trabajadores.js"></script>
