<?php
require_once __DIR__ . '/../templates/header.php';
require_once __DIR__ . '/../templates/navbar.php';   // ← nuevo
require_once __DIR__ . '/../templates/sidebar.php';
require_once "../../config/conexion.php";
// Obtener trabajadores
$trabajadores = [];
$resultado = $conexion->query("SELECT id, nombre FROM trabajadores");
while ($fila = $resultado->fetch_assoc()) {
    $trabajadores[] = $fila;
}
?>

<!-- Contenido principal -->
<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <h2 class="mb-4">Reportes</h2>
    </div>
  </div>

  <section class="content">
    <div class="container-fluid">

      <!-- Reporte Stock Actual -->
      <div class="card">
        <div class="card-header bg-primary text-white">
          <h5 class="mb-0">Stock actual de productos</h5>
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table id="tablaStock" class="table table-bordered table-striped display nowrap" style="width:100%">
              <thead class="thead-dark">
                <tr>
                  <th>#</th>
                  <th>Producto</th>
                  <th>Tipo</th>
                  <th>Categoría</th>
                  <th>Medida</th>
                  <th>Stock</th>
                </tr>
              </thead>
              <tbody></tbody>
            </table>
          </div>
        </div>
      </div>

      <!-- Reporte Productos No Devueltos -->
      <div class="card">
        <div class="card-header bg-warning text-dark">
          <h5 class="mb-0">Productos no devueltos</h5>
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table id="tablaNoDevueltos" class="table table-bordered table-striped display nowrap" style="width:100%">
              <thead class="thead-dark">
                <tr>
                  <th>Producto</th>
                  <th>Responsable</th>
                  <th>Fecha salida</th>
                  <th>Fecha retorno</th>
                  <th>Estado</th>
                </tr>
              </thead>
              <tbody></tbody>
            </table>
          </div>
        </div>
      </div>

      <!-- Reporte Movimientos por Trabajador -->
      <div class="card">
        <div class="card-header bg-info text-white">
          <h5 class="mb-0">Movimientos por Trabajador</h5>
        </div>
        <div class="card-body">
          <div class="form-group">
            <label for="selectTrabajador">Selecciona Trabajador:</label>
            <select id="selectTrabajador" class="form-control">
              <option value="">-- Seleccionar --</option>
              <?php foreach ($trabajadores as $trabajador): ?>
                <option value="<?= $trabajador['id'] ?>"><?= htmlspecialchars($trabajador['nombre']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="table-responsive mt-3">
            <table id="tablaPorTrabajador" class="table table-bordered table-striped display nowrap" style="width:100%">
              <thead class="thead-dark">
                <tr>
                  <th>Producto</th>
                  <th>Fecha salida</th>
                  <th>Fecha retorno</th>
                  <th>Estado</th>
                </tr>
              </thead>
              <tbody></tbody>
            </table>
          </div>
        </div>
      </div>

    </div>
  </section>
</div>

<?php require_once "../templates/footer.php"; ?>
<script src="<?= BASE_URL ?>assets/js/reportes.js?v=<?= time() ?>"></script>
