<?php
session_start();
if (!isset($_SESSION['usuario_id'])) {
  header("Location: ../../login.php");
  exit();
}

require_once __DIR__ . '/../templates/header.php';
require_once __DIR__ . '/../templates/navbar.php';   // ← nuevo
require_once __DIR__ . '/../templates/sidebar.php';
?>

<div class="content-wrapper">
  <section class="content-header d-flex justify-content-between align-items-center">
    <h1>Gestión de Medidas</h1>
    <button class="btn btn-primary" onclick="mostrarModal()">
      <i class="fas fa-plus"></i> Nueva Medida
    </button>
  </section>

  <section class="content">
    <div class="card">
      <div class="card-body">
        <div class="table-responsive">
          <table id="tablaMedidas" class="table table-bordered table-striped">
            <thead class="thead-dark">
              <tr>
                <th>ID</th>
                <th>Medida</th>
                <th>Acción</th>
              </tr>
            </thead>
            <tbody>
              <?php
              include '../../config/conexion.php';
              $query = $conexion->query("SELECT * FROM medidas ORDER BY id DESC");
              while ($row = $query->fetch_assoc()):
              ?>
              <tr>
                <td><?= $row['id'] ?></td>
                <td><?= htmlspecialchars($row['nombre']) ?></td>
                <td>
                  <form method="POST" action="../../controllers/eliminar_medida.php" onsubmit="return confirm('¿Está seguro de eliminar esta medida?');" class="d-inline">
                    <input type="hidden" name="id" value="<?= $row['id'] ?>">
                    <button class="btn btn-danger btn-sm" type="submit"><i class="fas fa-trash-alt"></i> Eliminar</button>
                  </form>
                </td>
              </tr>
              <?php endwhile; $conexion->close(); ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </section>
</div>

<!-- Modal -->
<div class="modal fade" id="modalProducto" tabindex="-1" role="dialog" aria-labelledby="modalLabel" aria-hidden="true">
  <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
    <div class="modal-content">
      <form method="POST" action="../../controllers/guardar_medida.php">
        <div class="modal-header bg-primary text-white">
          <h5 class="modal-title" id="modalLabel">Registrar Nueva Medida</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <label for="nombre">Nombre de la medida:</label>
          <input type="text" name="nombre" class="form-control" required>
        </div>
        <div class="modal-footer">
          <button type="submit" name="registrar" class="btn btn-success">Registrar</button>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Scripts -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap4.min.css">
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

<script>
  $(document).ready(function () {
    $('#tablaMedidas').DataTable({
      dom: 'Bfrtip',
      buttons: ['excel', 'print'],
      pageLength: 5,
      language: {
        search: "Buscar:",
        lengthMenu: "Mostrar _MENU_ registros",
        info: "Mostrando _START_ a _END_ de _TOTAL_",
        paginate: {
          first: "Primero", last: "Último",
          next: "Siguiente", previous: "Anterior"
        },
        emptyTable: "No hay datos disponibles"
      }
    });
  });

  function mostrarModal() {
    $('#modalProducto').modal('show');
  }
</script>

<?php include '../templates/footer.php'; ?>
