<?php
session_start();
if (!isset($_SESSION['usuario'])) {
    header("Location: ../../login.php");
    exit();
}
require_once __DIR__ . '/../templates/header.php';
require_once __DIR__ . '/../templates/navbar.php';   // ← nuevo
require_once __DIR__ . '/../templates/sidebar.php';

// Procesar devolución
if (isset($_GET['devolver'])) {
    $id = $_GET['devolver'];
    $conexion->query("UPDATE asignaciones SET estado = 'devuelto' WHERE id = $id");
    header("Location: listar_asignaciones.php");
    exit();
}
?>

<h2>Asignaciones de Productos</h2>

<table border="1" cellpadding="8" cellspacing="0">
    <thead>
        <tr>
            <th>Trabajador</th>
            <th>Producto (Código)</th>
            <th>Salida</th>
            <th>Retorno</th>
            <th>Estado</th>
            <th>Acción</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $asignaciones = $conexion->query("SELECT * FROM asignaciones ORDER BY fecha_salida DESC");
        while ($row = $asignaciones->fetch_assoc()) {
            echo "<tr>
                    <td>{$row['cliente']}</td>
                    <td>{$row['producto_codigo']}</td>
                    <td>{$row['fecha_salida']}</td>
                    <td>{$row['fecha_retorno']}</td>
                    <td><strong>" . strtoupper($row['estado']) . "</strong></td>
                    <td>";
            if ($row['estado'] === 'pendiente') {
                echo "<a href='listar_asignaciones.php?devolver={$row['id']}' onclick=\"return confirm('¿Confirmar devolución?')\">Marcar como devuelto</a>";
            } else {
                echo "✔";
            }
            echo "</td></tr>";
        }
        ?>
    </tbody>
</table>

<?php include '../templates/footer.php'; ?>
