<?php
require_once '../../config/conexion.php';

if (!isset($_GET['id'])) {
    die('ID de movimiento no especificado.');
}

$id = intval($_GET['id']);

$sql = "SELECT m.*, 
               p.nombre AS producto,
               t.nombre AS trabajador
        FROM movimientos m
        LEFT JOIN productos p ON m.producto_id = p.id
        LEFT JOIN trabajadores t ON m.trabajador_id = t.id
        WHERE m.id = ?";
$stmt = $conexion->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();
$resultado = $stmt->get_result();

if ($resultado->num_rows === 0) {
    die('Movimiento no encontrado.');
}

$mov = $resultado->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Ticket Movimiento #<?= $mov['id'] ?></title>
  <style>
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background-color: #f4f4f4;
      padding: 30px;
    }
    .ticket {
      background-color: #fff;
      border: 2px solid #4e73df;
      border-radius: 10px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
      padding: 20px 25px;
      width: 360px;
      margin: auto;
    }
    .ticket h2 {
      text-align: center;
      color: #4e73df;
      margin-bottom: 20px;
    }
    .ticket p {
      margin: 6px 0;
      font-size: 15px;
    }
    .acciones {
      text-align: center;
      margin-top: 25px;
    }
    .acciones button {
      margin: 6px;
      padding: 8px 16px;
      font-size: 14px;
      background-color: #4e73df;
      color: #fff;
      border: none;
      border-radius: 6px;
      cursor: pointer;
    }
    .acciones button:hover {
      background-color: #2e59d9;
    }
    @media print {
      .acciones {
        display: none;
      }
    }
  </style>
</head>
<body>
  <div class="ticket" id="ticketContent">
    <h2>Movimiento #<?= $mov['id'] ?></h2>
    <p><strong>Producto:</strong> <?= $mov['producto'] ?></p>
    <p><strong>Tipo:</strong> <?= $mov['tipo_movimiento'] === 'con_retorno' ? 'Con retorno' : 'Sin retorno' ?></p>
    <p><strong>Responsable:</strong> <?= $mov['trabajador'] ?: $mov['cliente_responsable'] ?></p>
    <p><strong>Cantidad:</strong> <?= $mov['cantidad'] ?></p>
    <p><strong>Motivo:</strong> <?= $mov['motivo'] ?></p>
    <p><strong>Fecha de Salida:</strong> <?= date('d/m/Y H:i', strtotime($mov['fecha'])) ?></p>
    <?php if (!empty($mov['fecha_retorno'])): ?>
      <p><strong>Fecha de Retorno:</strong> <?= date('d/m/Y', strtotime($mov['fecha_retorno'])) ?></p>
    <?php endif; ?>
    <p><strong>Estado:</strong> <?= ucfirst($mov['estado_retorno']) ?></p>
  </div>

  <div class="acciones">
    <button onclick="window.print()">🖨️ Imprimir</button>
    <button onclick="descargarPDF()">📥 Descargar PDF</button>
  </div>

  <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
  <script>
    function descargarPDF() {
      const element = document.getElementById("ticketContent");
      const opt = {
        margin:       0.3,
        filename:     'ticket_movimiento_<?= $mov['id'] ?>.pdf',
        image:        { type: 'jpeg', quality: 0.98 },
        html2canvas:  { scale: 2 },
        jsPDF:        { unit: 'in', format: 'letter', orientation: 'portrait' }
      };
      html2pdf().from(element).set(opt).save();
    }
  </script>
</body>
</html>
