<?php
session_start();
if (!isset($_SESSION['usuario_id'])) {
  header("Location: ../../login.php");
  exit();
}

require_once __DIR__ . '/../templates/header.php';
require_once __DIR__ . '/../templates/navbar.php';   //  nuevo
require_once __DIR__ . '/../templates/sidebar.php';
?>

<!-- Encabezado -->
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h2 class="m-0">Entradas y Salidas</h2>
            </div>
        </div>
    </div>
</div>

<!-- Contenido principal -->
<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-6 mx-auto">
                <div class="card card-info shadow">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fas fa-random"></i> Registrar Movimiento</h3>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="../../../controllers/guardar_movimiento.php">
                            <div class="form-group">
                                <label for="codigo">Código de Producto</label>
                                <div class="input-group">
                                    <input type="text" name="codigo" id="codigo" class="form-control" required>
                                    <div class="input-group-append">
                                        <button type="button" class="btn btn-secondary" onclick="toggleQR()">
                                            <i class="fas fa-qrcode"></i>
                                        </button>
                                    </div>
                                </div>
                                <video id="qr-video" width="100%" style="display: none; margin-top: 10px;"></video>
                            </div>
                            <div class="form-group">
                                <label for="tipo">Tipo de Movimiento</label>
                                <select name="tipo" id="tipo" class="form-control" required>
                                    <option value="">Seleccione</option>
                                    <option value="entrada">Entrada</option>
                                    <option value="salida">Salida</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="cantidad">Cantidad</label>
                                <input type="number" name="cantidad" id="cantidad" class="form-control" required min="1">
                            </div>
                            <div class="form-group">
                                <label for="motivo">Motivo</label>
                                <textarea name="motivo" id="motivo" class="form-control" rows="2" required></textarea>
                            </div>
                            <button type="submit" name="registrar" class="btn btn-info btn-block">
                                <i class="fas fa-save"></i> Registrar
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- QR Scanner -->
<script src="https://cdn.jsdelivr.net/npm/qr-scanner@1.4.2/qr-scanner.min.js"></script>
<script>
    const video = document.getElementById('qr-video');
    const input = document.getElementById('codigo');
    let qrScanner;

    function toggleQR() {
        if (video.style.display === 'none') {
            video.style.display = 'block';
            qrScanner = new QrScanner(video, result => {
                input.value = result;
                qrScanner.stop();
                video.style.display = 'none';
            });
            qrScanner.start();
        } else {
            qrScanner.stop();
            video.style.display = 'none';
        }
    }
</script>
<?php include '../templates/footer.php'; ?>

