<?php
session_start();
if (!isset($_SESSION['usuario'])) {
    header("Location: ../../login.php");
    exit();
}
require_once __DIR__ . '/../templates/header.php';
require_once __DIR__ . '/../templates/navbar.php';   //  nuevo
require_once __DIR__ . '/../templates/sidebar.php';
?>

<h2>Asignar Producto a Trabajador</h2>

<!-- Formulario de asignación -->
<form method="POST" action="../../controllers/AsignacionController.php">
    <label>Trabajador (nombre):</label><br>
    <input type="text" name="cliente" required><br><br>

    <label>Producto (código):</label><br>
    <input type="text" name="producto_codigo" id="producto_codigo" required>
    <button type="button" onclick="iniciarQR()">📷 QR</button><br><br>

    <label>Fecha de salida:</label><br>
    <input type="date" name="fecha_salida" required><br><br>

    <label>Fecha estimada de retorno:</label><br>
    <input type="date" name="fecha_retorno" required><br><br>

    <button type="submit" name="asignar">Guardar asignación</button>
</form>

<!-- Visor QR -->
<div id="preview" style="margin-top:10px;"></div>

<script src="https://cdn.jsdelivr.net/npm/qr-scanner@1.4.2/qr-scanner.umd.min.js"></script>
<script>
function iniciarQR() {
    const video = document.createElement('video');
    document.getElementById('preview').innerHTML = '';
    document.getElementById('preview').appendChild(video);
    const qrScanner = new QrScanner(video, result => {
        document.getElementById('producto_codigo').value = result;
        qrScanner.stop();
        document.getElementById('preview').innerHTML = '';
    });
    qrScanner.start();
}
</script>

<?php include '../templates/footer.php'; ?>
