<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../vendor/PHPMailer/src/Exception.php';
require '../vendor/PHPMailer/src/PHPMailer.php';
require '../vendor/PHPMailer/src/SMTP.php';
require '../config/conexion.php';

// Obtener asignaciones vencidas
$hoy = date('Y-m-d');
$sql = "SELECT * FROM asignaciones WHERE estado = 'pendiente' AND fecha_retorno < ?";
$stmt = $conexion->prepare($sql);
$stmt->bind_param("s", $hoy);
$stmt->execute();
$resultado = $stmt->get_result();

if ($resultado->num_rows > 0) {
    $mensaje = "<h3>Productos no devueltos</h3><ul>";
    while ($row = $resultado->fetch_assoc()) {
        $mensaje .= "<li>{$row['cliente']} no devolvió el producto {$row['producto_codigo']} (fecha límite: {$row['fecha_retorno']})</li>";
    }
    $mensaje .= "</ul>";

    // Configurar PHPMailer
    $mail = new PHPMailer(true);

    try {
        $mail->isSMTP();
        $mail->Host = 'smtp.tu-servidor.com'; // por ejemplo smtp.gmail.com
        $mail->SMTPAuth = true;
        $mail->Username = 'tucorreo@dominio.com'; // tu correo
        $mail->Password = 'tu-contraseña'; // tu clave
        $mail->SMTPSecure = 'tls';
        $mail->Port = 587;

        $mail->setFrom('tucorreo@dominio.com', 'ALMACENCRM');
        $mail->addAddress('destinatario@dominio.com'); // puede ser tu correo de monitoreo

        $mail->isHTML(true);
        $mail->Subject = '⚠️ Alerta: Productos no devueltos';
        $mail->Body = $mensaje;

        $mail->send();
        echo "Correo enviado correctamente.";
    } catch (Exception $e) {
        echo "Error al enviar correo: {$mail->ErrorInfo}";
    }
} else {
    echo "No hay productos pendientes vencidos.";
}
?>
