<?php
if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__ . '/../config/conexion.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: ../login.php");
    exit;
}

$usuario  = isset($_POST['usuario']) ? trim($_POST['usuario']) : '';
$password = $_POST['password'] ?? '';

if ($usuario === '' || $password === '') {
    header("Location: ../login.php?error=1");
    exit;
}

$stmt = $conexion->prepare("SELECT id, usuario, password, nombre, rol, estado FROM usuarios WHERE usuario = ? LIMIT 1");
$stmt->bind_param('s', $usuario);
$stmt->execute();
$stmt->store_result();

if ($stmt->num_rows === 1) {
    $stmt->bind_result($id, $usuarioDB, $passwordHash, $nombre, $rol, $estado);
    $stmt->fetch();

    if ((int)$estado === 1 && password_verify($password, $passwordHash)) {
        $_SESSION['usuario_id']     = $id;
        $_SESSION['usuario_nombre'] = $nombre;
        $_SESSION['usuario_rol']    = $rol;
        $_SESSION['usuario']        = $nombre;

        header("Location: ../views/modulos/dashboard.php");
        exit;
    }
}

header("Location: ../login.php?error=1");
exit;
