<?php
require_once '../config/conexion.php';
require_once 'enviar_correo.php';
require_once 'enviar_whatsapp.php';

$hoy = date('Y-m-d');
$mañana = date('Y-m-d', strtotime('+1 day'));

$consulta = "SELECT m.*, t.nombre AS trabajador, t.correo, t.telefono, p.nombre AS producto
             FROM movimientos m
             JOIN trabajadores t ON m.trabajador_id = t.id
             JOIN productos p ON m.producto_id = p.id
             WHERE m.estado_retorno = 'pendiente'
               AND (m.fecha_retorno = ? OR m.fecha_retorno = ?)";

$stmt = $conexion->prepare($consulta);
$stmt->bind_param("ss", $hoy, $mañana);
$stmt->execute();
$resultado = $stmt->get_result();

while ($fila = $resultado->fetch_assoc()) {
    $mensaje = "🔔 Recordatorio: El producto '{$fila['producto']}' debe ser devuelto el {$fila['fecha_retorno']}.";

    // Enviar correo
    if (!empty($fila['correo'])) {
        enviarCorreo($fila['correo'], "Producto por vencer", $mensaje);
    }

    // Enviar WhatsApp
    if (!empty($fila['telefono'])) {
        enviarWhatsapp($fila['telefono'], $mensaje);
    }
}
?>
