<?php
include '../config/conexion.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id_movimiento']; // nombre correcto según el formulario

    // Obtener información del movimiento
    $stmt = $conexion->prepare("SELECT producto_id, cantidad FROM movimientos WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 0) {
        header("Location: ../views/modulos/listar_movimientos.php?error=notfound");
        exit();
    }

    $stmt->bind_result($producto_id, $cantidad);
    $stmt->fetch();
    $stmt->close();

    // 1. Actualizar estado a 'devuelto'
    $update = $conexion->prepare("UPDATE movimientos SET estado = 'devuelto' WHERE id = ?");
    $update->bind_param("i", $id);
    $update->execute();

    // 2. Sumar al stock del producto
    $update_stock = $conexion->prepare("UPDATE productos SET stock = stock + ? WHERE id = ?");
    $update_stock->bind_param("ii", $cantidad, $producto_id);
    $update_stock->execute();

    // Redirigir con mensaje de éxito
    header("Location: ../views/modulos/listar_movimientos.php?mensaje=devuelto");
    exit();
} else {
    header("Location: ../views/modulos/listar_movimientos.php");
    exit();
}
