<?php
require_once "../config/conexion.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? '';
    $nombre = $_POST['nombre'] ?? '';
    $usuario = $_POST['usuario'] ?? '';
    $password = $_POST['password'] ?? '';
    $rol = $_POST['rol'] ?? '';
    $email = $_POST['email'] ?? '';
    $estado = $_POST['estado'] ?? 1;

    if (empty($nombre) || empty($usuario) || empty($rol)) {
        echo json_encode(['success' => false, 'message' => 'Faltan campos obligatorios']);
        exit;
    }

    if ($id == '') {
        // Insertar nuevo
        $hashed = password_hash($password, PASSWORD_BCRYPT);
        $stmt = $conexion->prepare("INSERT INTO usuarios (nombre, usuario, password, rol, email, estado) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("sssssi", $nombre, $usuario, $hashed, $rol, $email, $estado);
        $stmt->execute();
        echo json_encode(['success' => true, 'message' => 'Usuario registrado']);
    } else {
        // Actualizar existente
        if (!empty($password)) {
            $hashed = password_hash($password, PASSWORD_BCRYPT);
            $stmt = $conexion->prepare("UPDATE usuarios SET nombre=?, usuario=?, password=?, rol=?, email=?, estado=? WHERE id=?");
            $stmt->bind_param("ssssssi", $nombre, $usuario, $hashed, $rol, $email, $estado, $id);
        } else {
            $stmt = $conexion->prepare("UPDATE usuarios SET nombre=?, usuario=?, rol=?, email=?, estado=? WHERE id=?");
            $stmt->bind_param("ssssii", $nombre, $usuario, $rol, $email, $estado, $id);
        }
        $stmt->execute();
        echo json_encode(['success' => true, 'message' => 'Usuario actualizado']);
    }
}
