<?php
require_once '../config/conexion.php';
header('Content-Type: application/json');

$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$nombre = trim($_POST['nombre'] ?? '');
$categoria_id = isset($_POST['categoria_id']) && $_POST['categoria_id'] !== '' ? (int)$_POST['categoria_id'] : 0;

if ($nombre === '' || $categoria_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Nombre y categoría son obligatorios']);
    exit;
}

if ($id > 0) {
    // Editar
    $stmt = $conexion->prepare("UPDATE tipos SET nombre = ?, categoria_id = ? WHERE id = ?");
    $stmt->bind_param("sii", $nombre, $categoria_id, $id);
} else {
    // Insertar
    $stmt = $conexion->prepare("INSERT INTO tipos (nombre, categoria_id) VALUES (?, ?)");
    $stmt->bind_param("si", $nombre, $categoria_id);
}

if ($stmt->execute()) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => 'Error al guardar']);
}
