<?php
include '../config/conexion.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $codigo = $_POST['codigo'];
    $tipo = $_POST['tipo']; // entrada o salida
    $trabajador = $_POST['trabajador'];
    $cantidad = (int) $_POST['cantidad'];
    $motivo = $_POST['motivo'];
    $fecha_retorno = $_POST['fecha_retorno'];

    // Buscar producto por código
    $stmt = $conexion->prepare("SELECT id, stock FROM productos WHERE codigo = ?");
    $stmt->bind_param("s", $codigo);
    $stmt->execute();
    $resultado = $stmt->get_result();

    if ($resultado->num_rows === 0) {
        echo "Producto no encontrado.";
        exit();
    }

    $producto = $resultado->fetch_assoc();
    $id_producto = $producto['id'];
    $stock_actual = (int) $producto['stock'];

    // Calcular nuevo stock
    if ($tipo === 'entrada') {
        $nuevo_stock = $stock_actual + $cantidad;
    } elseif ($tipo === 'salida') {
        if ($cantidad > $stock_actual) {
            echo "Error: Stock insuficiente para salida.";
            exit();
        }
        $nuevo_stock = $stock_actual - $cantidad;
    } else {
        echo "Tipo de movimiento inválido.";
        exit();
    }

    // Registrar movimiento
    $stmt = $conexion->prepare("INSERT INTO movimientos (producto_id, trabajador, tipo_movimiento, cantidad, motivo, fecha_salida, fecha_retorno, estado) 
        VALUES (?, ?, ?, ?, ?, NOW(), ?, 'pendiente')");
    $stmt->bind_param("ississ", $id_producto, $trabajador, $tipo, $cantidad, $motivo, $fecha_retorno);
    $stmt->execute();

    // Actualizar stock
    $stmt = $conexion->prepare("UPDATE productos SET stock = ? WHERE id = ?");
    $stmt->bind_param("ii", $nuevo_stock, $id_producto);
    $stmt->execute();

    header("Location: ../views/modulos/movimientos.php?mensaje=registrado");
    exit();
} else {
    echo "Acceso no permitido.";
}
