<?php
include '../config/conexion.php';
header('Content-Type: application/json');

$datos = [];

// Productos por categoría
$categoria = $conexion->query("SELECT c.nombre AS categoria, COUNT(*) AS total FROM productos p JOIN categorias c ON p.categoria_id = c.id GROUP BY c.nombre");
$datos['categorias'] = [];
$datos['totales'] = [];
while ($row = $categoria->fetch_assoc()) {
    $datos['categorias'][] = $row['categoria'];
    $datos['totales'][] = $row['total'];
}

// Movimientos por mes
$movimientos = $conexion->query("SELECT DATE_FORMAT(fecha_salida, '%b') AS mes, COUNT(*) AS total FROM movimientos GROUP BY mes ORDER BY MONTH(STR_TO_DATE(mes, '%b'))");
$datos['meses'] = [];
$datos['cantidades'] = [];
while ($row = $movimientos->fetch_assoc()) {
    $datos['meses'][] = $row['mes'];
    $datos['cantidades'][] = $row['total'];
}

echo json_encode($datos);
