document.addEventListener("DOMContentLoaded", function () {
  cargarUsuarios();

  const form = document.getElementById("formUsuario");
  form.addEventListener("submit", function (e) {
    e.preventDefault();
    const datos = new FormData(form);

    fetch("../../controllers/guardar_usuario.php", {
      method: "POST",
      body: datos
    })
      .then(res => res.json())
      .then(respuesta => {
        if (respuesta.success) {
          $("#modalUsuario").modal("hide");
          form.reset();
          cargarUsuarios();
          Swal.fire("Éxito", respuesta.message, "success");
        } else {
          Swal.fire("Error", respuesta.message, "error");
        }
      });
  });
});

function cargarUsuarios() {
  fetch("../../ajax/usuarios_ajax.php?accion=obtener")
    .then(res => res.json())
    .then(data => {
      const tbody = document.querySelector("#tablaUsuarios tbody");
      tbody.innerHTML = "";
      data.forEach((usuario, index) => {
        let acciones = "";
        if (usuario.permisos.includes("editar")) {
          acciones += `<button class="btn btn-warning btn-sm mr-1" onclick="editarUsuario(${usuario.id})"><i class="fas fa-edit"></i></button>`;
        }
        if (usuario.permisos.includes("eliminar")) {
          acciones += `<button class="btn btn-danger btn-sm" onclick="eliminarUsuario(${usuario.id})"><i class="fas fa-trash-alt"></i></button>`;
        }

        tbody.innerHTML += `
          <tr>
            <td>${index + 1}</td>
            <td>${usuario.nombre}</td>
            <td>${usuario.usuario}</td>
            <td>${usuario.rol}</td>
            <td>${usuario.email}</td>
            <td>${usuario.estado == 1 ? "Activo" : "Inactivo"}</td>
            ${usuario.permisos.length ? `<td>${acciones}</td>` : ""}
          </tr>
        `;
      });
    });
}

function editarUsuario(id) {
  fetch(`../../ajax/usuarios_ajax.php?accion=obtenerUno&id=${id}`)
    .then(res => res.json())
    .then(usuario => {
      document.getElementById("id").value = usuario.id;
      document.getElementById("nombre").value = usuario.nombre;
      document.getElementById("usuario").value = usuario.usuario;
      document.getElementById("email").value = usuario.email;
      document.getElementById("rol").value = usuario.rol;
      document.getElementById("estado").value = usuario.estado;
      document.getElementById("password").value = ""; // dejar vacío
      $("#modalUsuario").modal("show");
    });
}

function eliminarUsuario(id) {
  Swal.fire({
    title: "¿Eliminar usuario?",
    text: "Esta acción no se puede deshacer",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, eliminar",
    cancelButtonText: "Cancelar"
  }).then(result => {
    if (result.isConfirmed) {
      fetch(`../../controllers/eliminar_usuario.php?id=${id}`, {
        method: "GET"
      })
        .then(res => res.json())
        .then(respuesta => {
          if (respuesta.success) {
            Swal.fire("Eliminado", respuesta.message, "success");
            cargarUsuarios();
          } else {
            Swal.fire("Error", respuesta.message, "error");
          }
        });
    }
  });
}
