document.addEventListener("DOMContentLoaded", function () {
  cargarTipos();

  const form = document.getElementById("formTipo");
  form.addEventListener("submit", function (e) {
    e.preventDefault();
    const datos = new FormData(form);

    fetch("../../controllers/guardar_tipo.php", {
      method: "POST",
      body: datos
    })
    .then(res => res.json())
    .then(respuesta => {
      if (respuesta.success) {
        $('#modalTipo').modal('hide');
        form.reset();
        cargarTipos();
        Swal.fire({ icon: 'success', title: 'Guardado correctamente', showConfirmButton: false, timer: 1500 });
        window.scrollTo({ top: 0, behavior: 'smooth' });
      } else {
        Swal.fire({ icon: 'error', title: 'Error', text: respuesta.message });
      }
    })
    .catch(() => Swal.fire({ icon: 'error', title: 'Error de red' }));
  });
});

function cargarTipos() {
  fetch("../../ajax/tipo_ajax.php?accion=obtener")
    .then(res => res.json())
    .then(data => {
      const tbody = document.querySelector("#tablaTipos tbody");
      tbody.innerHTML = "";
      data.forEach(tipo => {
        const categoria = tipo.categoria_nombre || '—';
        tbody.innerHTML += `
          <tr>
            <td>${tipo.id}</td>
            <td>${tipo.nombre}</td>
            <td>${categoria}</td> <!-- NUEVO -->
            <td>
              <button class="btn btn-sm btn-warning" onclick='editarTipo(${JSON.stringify(tipo)})'>
                <i class="fas fa-edit"></i>
              </button>
              <button class="btn btn-sm btn-danger" onclick='eliminarTipo(${tipo.id})'>
                <i class="fas fa-trash"></i>
              </button>
            </td>
          </tr>`;
      });
    });
}

// Cargar categorías en el select del modal
function cargarCategoriasParaTipos(preselectId = "") {
  return fetch('../../ajax/categoria_ajax.php')
    .then(r => r.json())
    .then(data => {
      const sel = document.getElementById('tipo_categoria_id');
      let html = '<option value="">Seleccione...</option>';
      data.forEach(c => html += `<option value="${c.id}">${c.nombre}</option>`);
      sel.innerHTML = html;
      if (preselectId) sel.value = String(preselectId);
    })
    .catch(() => Swal.fire('Error', 'No se pudieron cargar categorías', 'error'));
}

// Mostrar modal para nuevo tipo
function mostrarModal() {
  const form = document.getElementById("formTipo");
  form.reset();
  document.getElementById("tipo_id").value = "";
  cargarCategoriasParaTipos().then(() => { $('#modalTipo').modal('show'); });
}

// Editar tipo (preselecciona categoría y nombre)
function editarTipo(tipo) {
  document.getElementById("tipo_id").value = tipo.id;
  document.getElementById("nombre").value = tipo.nombre;
  cargarCategoriasParaTipos(tipo.categoria_id).then(() => { $('#modalTipo').modal('show'); });
}

function eliminarTipo(id) {
  if (confirm("¿Eliminar este tipo?")) {
    fetch("../../controllers/eliminar_tipo.php", {
      method: "POST",
      body: new URLSearchParams({ id })
    })
    .then(res => res.json())
    .then(resp => {
      if (resp.success) {
        cargarTipos();
        Swal.fire({ icon: 'success', title: 'Eliminado correctamente', showConfirmButton: false, timer: 1200 });
      } else {
        Swal.fire({ icon: 'error', title: 'Error', text: resp.message });
      }
    })
    .catch(() => Swal.fire({ icon: 'error', title: 'Error de red' }));
  }
}
