document.addEventListener("DOMContentLoaded", function () {
  cargarProductos(); // Llenar select de productos
  cargarRegistroDefectuosos();
  cargarDevueltosDefectuosos();

  const form = document.getElementById("formRegistrarDefectuoso");
  form.addEventListener("submit", function (e) {
    e.preventDefault();

    const datos = new FormData(form);
    fetch("../../controllers/guardar_producto_defectuoso.php", {
      method: "POST",
      body: datos
    })
    .then(res => res.json())
    .then(respuesta => {
      if (respuesta.success) {
        $('#modalRegistrarDefectuoso').modal('hide');
        form.reset();
        cargarRegistroDefectuosos();
        Swal.fire("Éxito", respuesta.message, "success");
      } else {
        Swal.fire("Error", respuesta.message, "error");
      }
    })
    .catch(error => {
      console.error("Error:", error);
      Swal.fire("Error", "No se pudo registrar el producto defectuoso", "error");
    });
  });
});

// Cargar productos válidos para el formulario
function cargarProductos() {
  fetch("../../ajax/productos_ajax.php?accion=obtener")
    .then(res => res.json())
    .then(data => {
      const select = document.getElementById("producto_id");
      select.innerHTML = '<option value="">Seleccione</option>';
      data.forEach(prod => {
        if (parseInt(prod.tipo_id) !== 1) { // Excluir los defectuosos
          select.innerHTML += `<option value="${prod.id}">${prod.nombre}</option>`;
        }
      });
    })
    .catch(error => {
      console.error("Error al cargar productos:", error);
    });
}

// Cargar productos defectuosos registrados directamente
function cargarRegistroDefectuosos() {
  const selector = '#tablaRegistroDefectuosos';
  fetch('../../ajax/productos_defectuosos_ajax.php?accion=registro')
    .then(res => res.json())
    .then(data => {
      destruirDataTable(selector);
      const tbody = document.querySelector(selector + ' tbody');
      tbody.innerHTML = "";

      data.forEach(row => {
        tbody.innerHTML += `
          <tr>
            <td>${row.id}</td>
            <td>${row.nombre}</td>
            <td>${row.codigo_qr || '-'}</td>
            <td>${row.cantidad}</td>
            <td>${row.fecha_registro}</td>
            <td>${row.descripcion || '-'}</td>
            <td>${row.observacion || '-'}</td>
          </tr>`;
      });

      inicializarDataTable(selector);
    })
    .catch(error => {
      console.error("Error al cargar productos defectuosos:", error);
    });
}

// Cargar productos devueltos como defectuosos desde movimientos
function cargarDevueltosDefectuosos() {
  const selector = '#tablaDevueltosDefectuosos';
  fetch('../../ajax/productos_defectuosos_ajax.php?accion=devueltos')
    .then(res => res.json())
    .then(data => {
      destruirDataTable(selector);
      const tbody = document.querySelector(selector + ' tbody');
      tbody.innerHTML = "";

      data.forEach(row => {
        tbody.innerHTML += `
          <tr>
            <td>${row.id}</td>
            <td>${row.nombre}</td>
            <td>${row.codigo_qr || '-'}</td>
            <td>${row.motivo || '-'}</td>
            <td>${row.responsable || '-'}</td>
            <td>${row.fecha_retorno || '-'}</td>
          </tr>`;
      });

      inicializarDataTable(selector);
    })
    .catch(error => {
      console.error("Error al cargar devueltos defectuosos:", error);
    });
}

// Inicializar DataTable (exportar y español)
function inicializarDataTable(selector) {
  $(selector).DataTable({
    pageLength: 5,
    responsive: true,
    language: {
      url: "//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json"
    },
    dom: 'Bfrtip',
    buttons: ['excel', 'print']
  });
}

// Destruir DataTable si ya está inicializado
function destruirDataTable(selector) {
  if ($.fn.DataTable.isDataTable(selector)) {
    $(selector).DataTable().destroy();
  }
}
