(function () {
  const getBaseUrl = () => (window.BASE_URL ? window.BASE_URL : '../../');

  // ===== Broadcast =====
  function broadcastRefresh() {
    try { localStorage.setItem('MOV_REFRESH', String(Date.now())); } catch (_) {}
    if (typeof window.cargarMovimientos === 'function') {
      try { window.cargarMovimientos(); } catch (_) {}
    }
  }

  // ===== Helpers =====
  function formatFechaCortaISO(yyyy_mm_dd) {
    if (!yyyy_mm_dd) return '';
    const d = new Date(String(yyyy_mm_dd) + 'T00:00:00');
    if (isNaN(d)) return '';
    const dd = String(d.getDate()).padStart(2, '0');
    const mm = String(d.getMonth() + 1).padStart(2, '0');
    const yy = d.getFullYear();
    return `${dd}/${mm}/${yy}`;
  }
  function escapeHtml(t){ if(t==null) return ''; return String(t).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;"); }
  function encodeAttr(t){ if(t==null) return ''; return String(t).replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/'/g,"&#039;").replace(/</g,"&lt;").replace(/>/g,"&gt;"); }
  function setValue(id,val){ const el=document.getElementById(id); if(el!=null) el.value=(val??''); }

  // ===== Estado global =====
  let dt = null;
  let productosCache = [];
  let inFlightCtrl = null;
  let reqId = 0;
  let lastAppliedId = 0;

  document.addEventListener("DOMContentLoaded", () => {
    cargarProductos();
    cargarCategorias();
    cargarMedidas();
    cargarTipos();

    window.addEventListener('storage', (e) => { if (e.key === 'MOV_REFRESH') cargarProductos(); });
    document.addEventListener('visibilitychange', () => { if (!document.hidden) cargarProductos(); });
    setInterval(() => { cargarProductos(); }, 60000);

    const formProducto = document.getElementById("formProducto");
    const btnNuevo = document.getElementById("btnNuevo");
    const btnEscanearQRGeneral = document.getElementById("btnEscanearQRGeneral");

    if (formProducto) formProducto.addEventListener("submit", (e) => { e.preventDefault(); guardarProducto(); });

    if (btnNuevo) {
      btnNuevo.addEventListener("click", () => {
        limpiarFormulario();
        $('#modalProducto').modal('show');
        setTimeout(() => { const codigo=document.getElementById("codigo"); if (codigo) codigo.focus(); }, 150);
      });
    }

    if (btnEscanearQRGeneral) {
      btnEscanearQRGeneral.addEventListener("click", () => {
        iniciarEscaneoQR();
        $('#modalEscanerQR').modal('show');
      });
    }

    const selectCategoria = document.getElementById("select_categoria");
    if (selectCategoria) {
      selectCategoria.addEventListener("change", () => {
        const catId = selectCategoria.value || "";
        cargarTipos(catId).then(() => {
          const selTipo = document.getElementById("select_tipo");
          if (selTipo) selTipo.value = "";
        });
      });
    }

    $('#modalEscanerQR').on('hidden.bs.modal', () => detenerEscaneoQR());

    // ===== submit ingreso rpido (robusto ante respuestas vacas/no-JSON) =====
    const formIngreso = document.getElementById('formIngresoRapido');
    if (formIngreso && !formIngreso.dataset.bound) {
      formIngreso.dataset.bound = "1";
      formIngreso.addEventListener('submit', (e) => {
        e.preventDefault();
        const producto_id = document.getElementById('ingreso_producto_id').value;
        const cantidad = parseInt(document.getElementById('ingreso_cantidad').value, 10);
        const motivo = document.getElementById('ingreso_motivo').value || null;

        if (!producto_id || !cantidad || cantidad <= 0) {
          return Swal.fire("Atencin", "Cantidad invlida.", "warning");
        }

        fetch("../../controllers/IngresosController.php", {
          method: "POST",
          body: new URLSearchParams({ producto_id, cantidad, motivo })
        })
        .then(async (r) => {
          const ct  = r.headers.get('content-type') || '';
          const txt = await r.text(); // siempre leer como texto primero
          let data = null;

          if (ct.includes('application/json') && txt.trim() !== '') {
            try { data = JSON.parse(txt); } catch (_) {}
          }

          if (!r.ok) {
            const msg = (data && data.message) || txt || ('HTTP ' + r.status);
            throw new Error(msg);
          }

          return data || { success: true, message: txt || 'OK' };
        })
        .then(resp => {
          if (resp && resp.success) {
            Swal.fire("07xito", "Ingreso registrado.", "success");
            $('#modalIngresoProducto').modal('hide');
            formIngreso.reset();
            if (typeof cargarProductos === 'function') cargarProductos();
            try { localStorage.setItem('MOV_REFRESH', String(Date.now())); } catch (_) {}
          } else {
            Swal.fire("Error", (resp && resp.message) || "No se pudo registrar el ingreso.", "error");
          }
        })
        .catch((err) => {
          Swal.fire("Error", (err && err.message) || "Falla de red o servidor.", "error");
        });
      });
    }

    // botn verde por delegacin
    $(document).on('click', '.btn-ingreso', function () {
      const id = $(this).data('id');
      const nombre = $(this).data('nombre') || '';
      abrirIngresoRapido(id, nombre);
    });
  });

  // ===== QR =====
  let scannerQR = null;
  function iniciarEscaneoQR() {
    const video = document.getElementById("video");
    if (video) video.classList.remove("d-none");
    if (scannerQR) { scannerQR.stop(); scannerQR.destroy(); scannerQR = null; }
    const QrScanner = window.QrScanner;
    if (!QrScanner) return Swal.fire("Error", "Librera de QR no cargada.", "error");
    scannerQR = new QrScanner(video, result => {
      const valor = (result && result.data) ? String(result.data).trim() : '';
      if (!valor) return;
      const codigo = document.getElementById("codigo");
      if (codigo) codigo.value = valor;
      const audio = new Audio("../../assets/sounds/beep.mp3"); audio.play().catch(()=>{});
      detenerEscaneoQR();
      $('#modalEscanerQR').modal('hide');
      Swal.fire("Listo", "Cdigo general capturado.", "success");
    }, { returnDetailedScanResult: true });
    QrScanner.hasCamera().then(h => { if (h) scannerQR.start(); else Swal.fire("Error","No se encontr cmara.","error"); })
      .catch(()=> Swal.fire("Error","No se pudo acceder a la cmara.","error"));
  }
  function detenerEscaneoQR() { const v=document.getElementById("video"); if (scannerQR){scannerQR.stop();scannerQR.destroy();scannerQR=null;} if (v) v.classList.add("d-none"); }

  // ===== Guardar =====
  function guardarProducto() {
    const form = document.getElementById("formProducto");
    const datos = new FormData(form);
    const codigo = String(datos.get("codigo") || '').trim();
    const nombre = String(datos.get("nombre") || '').trim();
    const fechaIngreso = String(datos.get("fecha_ingreso") || '').trim();
    if (!codigo) return Swal.fire("Atencin", "El cdigo (QR general) es obligatorio.", "warning");
    if (!nombre) return Swal.fire("Atencin", "El nombre es obligatorio.", "warning");
    datos.set("fecha_ingreso", fechaIngreso || '');
    fetch("../../controllers/ProductoController.php", { method:"POST", body: datos })
      .then(r=>r.json())
      .then(resp=>{
        if (resp.success){
          Swal.fire({title:"0307xito!",text:resp.message||"Guardado correctamente.",icon:"success",timer:1800,showConfirmButton:false});
          detenerEscaneoQR(); $('#modalProducto').modal('hide'); $('#modalEscanerQR').modal('hide');
          cargarProductos(); broadcastRefresh();
        } else Swal.fire("Error", resp.message || "No se pudo guardar.", "error");
      })
      .catch(()=> Swal.fire("Error","Hubo un problema al guardar el producto.","error"));
  }

  // ===== Construccin de filas =====
  function buildRow(producto, fallback) {
    const tr = document.createElement('tr');
    const imgUrl = producto.imagen ? (getBaseUrl() + 'uploads/productos/' + producto.imagen) : fallback;
    const isLow = Number(producto.stock || 0) <= Number(producto.stock_minimo || 0);
    if (isLow) tr.classList.add("table-danger");
    tr.innerHTML = `
      <td style="width:60px">
        <img src="${imgUrl}" onerror="this.onerror=null;this.src='${fallback}';"
             alt="" style="height:48px;width:48px;object-fit:cover;border-radius:6px;border:1px solid #ddd">
      </td>
      <td>${escapeHtml(producto.nombre)}</td>
      <td>${escapeHtml(producto.codigo)}</td>
      <td>${escapeHtml(producto.tipo || '')}</td>
      <td>${escapeHtml(producto.categoria || '')}</td>
      <td>${escapeHtml(producto.medida || '')}</td>
      <td>${Number(producto.stock || 0)}</td>
      <td>${formatFechaCortaISO(producto.fecha_ingreso) || 'Sin fecha'}</td>
      <td>
        <button class="btn btn-sm btn-success btn-ingreso"
                data-id="${producto.id}"
                data-nombre="${encodeAttr(producto.nombre)}"
                title="Ingresar stock">
          <i class="fas fa-arrow-down"></i>
        </button>
        <button class="btn btn-sm btn-info" title="Editar"
          onclick='editarProducto(${JSON.stringify(producto)})'>
          <i class="fas fa-edit"></i>
        </button>
        <button class="btn btn-sm btn-danger" title="Eliminar"
          onclick="eliminarProducto(${producto.id})">
          <i class="fas fa-trash"></i>
        </button>
      </td>`;
    return tr;
  }

  // ===== Render estable (sin re-crear DataTables) =====
  function renderTabla(productos) {
    const tableEl = document.getElementById('tablaProductos');
    const tbody = tableEl ? tableEl.querySelector('tbody') : null;
    if (!tbody) return;

    const fallback = "data:image/svg+xml;utf8," + encodeURIComponent(
      `<svg xmlns='http://www.w3.org/2000/svg' width='96' height='96'>
         <rect width='100%' height='100%' fill='#eee'/>
         <text x='50%' y='50%' font-size='12' fill='#888' text-anchor='middle' dominant-baseline='central'>Sin imagen</text>
       </svg>`
    );

    const rows = productos.map(p => buildRow(p, fallback));

    if (!dt) {
      tbody.innerHTML = '';
      rows.forEach(r => tbody.appendChild(r));
      dt = $(tableEl).DataTable({
        pageLength: 5,
        dom: 'Bfrtip',
        buttons: ['excelHtml5', 'print'],
        language: { url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json' }
      });
    } else {
      dt.clear();
      dt.rows.add(rows);
      dt.draw(false);
    }
  }

  // ===== Cargar (anti-race + cach) =====
  function cargarProductos() {
    const url = '../../ajax/productos.ajax.php?accion=obtener&t=' + Date.now();

    if ($('#modalProducto').hasClass('show') || $('#modalIngresoProducto').hasClass('show') || $('#modalEscanerQR').hasClass('show')) {
      return;
    }

    if (inFlightCtrl) { try { inFlightCtrl.abort(); } catch (_) {} }
    const ctrl = new AbortController();
    inFlightCtrl = ctrl;
    const myId = ++reqId;

    fetch(url, { cache: 'no-store', signal: ctrl.signal })
      .then(res => {
        const ct = res.headers.get('content-type') || '';
        if (!ct.includes('application/json')) throw new Error('Respuesta no JSON');
        return res.json();
      })
      .then(data => {
        if (myId < lastAppliedId) return;
        lastAppliedId = myId;

        if (!Array.isArray(data)) throw new Error('JSON no es array');
        const productosFiltrados = (data || []).filter(p => p.tipo_id != 1000);

        if (productosFiltrados.length === 0 && productosCache.length > 0) {
          console.warn('[productos] Respuesta vaca; se conserva el ltimo dataset.');
          renderTabla(productosCache);
          return;
        }

        productosCache = productosFiltrados;
        renderTabla(productosCache);
      })
      .catch(err => {
        if (err && err.name === 'AbortError') return;
        console.error("Error al cargar productos:", err);
        if (productosCache.length > 0) renderTabla(productosCache);
      });
  }

  // ===== Exponer =====
  window.cargarProductos = cargarProductos;

  // ===== Catlogos =====
  function cargarTipos(categoriaId = "") {
    const url = '../../ajax/tipo_ajax.php?accion=obtener' + (categoriaId ? `&categoria_id=${encodeURIComponent(categoriaId)}` : '');
    return fetch(url).then(r => r.json()).then(data => {
      const sel = document.getElementById("select_tipo"); if (!sel) return;
      let options = '<option selected value="">Seleccione un Tipo</option>';
      (data || []).forEach(t => options += `<option value="${t.id}">${escapeHtml(t.nombre)}</option>`);
      sel.innerHTML = options;
    }).catch(err => console.error("Error al cargar tipos:", err));
  }
  function cargarCategorias() {
    fetch('../../ajax/categoria_ajax.php').then(r => r.json()).then(data => {
      const sel = document.getElementById("select_categoria"); if (!sel) return;
      sel.innerHTML = '<option value="">Seleccione</option>';
      (data || []).forEach(i => sel.innerHTML += `<option value="${i.id}">${escapeHtml(i.nombre)}</option>`);
    }).catch(err => console.error("Error al cargar categoras:", err));
  }
  function cargarMedidas() {
    fetch('../../ajax/medida_ajax.php').then(r => r.json()).then(data => {
      const sel = document.getElementById("select_medida"); if (!sel) return;
      sel.innerHTML = '<option value="">Seleccione</option>';
      (data || []).forEach(i => sel.innerHTML += `<option value="${i.id}">${escapeHtml(i.nombre)}</option>`);
    }).catch(err => console.error("Error al cargar medidas:", err));
  }

  // ===== Acciones =====
  window.editarProducto = function (producto) {
    setValue("producto_id", producto.id);
    setValue("codigo", producto.codigo);
    setValue("nombre", producto.nombre);
    setValue("select_categoria", producto.categoria_id);
    setValue("select_medida", producto.medida_id);
    setValue("stock", producto.stock);
    setValue("stock_minimo", producto.stock_minimo);
    setValue("fecha_ingreso", producto.fecha_ingreso);

    const hid = document.getElementById("imagen_actual");
    const prev = document.getElementById("preview_imagen");
    if (hid) hid.value = producto.imagen || '';
    if (prev) {
      if (producto.imagen) { prev.src = getBaseUrl() + 'uploads/productos/' + producto.imagen; prev.classList.remove('d-none'); }
      else { prev.src = ''; prev.classList.add('d-none'); }
    }

    cargarTipos(producto.categoria_id).then(() => {
      const selTipo = document.getElementById("select_tipo");
      if (selTipo) selTipo.value = producto.tipo_id;
    });

    $('#modalProducto').modal('show');
  };

  window.eliminarProducto = function (id) {
    Swal.fire({
      title: "07Eliminar producto?",
      text: "Esta accin no se puede deshacer.",
      icon: "warning",
      showCancelButton: true,
      confirmButtonText: "S, eliminar",
      cancelButtonText: "Cancelar"
    }).then((r) => {
      if (r.isConfirmed) {
        fetch("../../controllers/ProductoController.php", { method: "POST", body: new URLSearchParams({ accion: "eliminar", id }) })
        .then(r => r.json())
        .then(resp => {
          if (resp.success) { Swal.fire("Eliminado", resp.message || "Producto eliminado.", "success"); cargarProductos(); broadcastRefresh(); }
          else { Swal.fire("Error", resp.message || "No se pudo eliminar.", "error"); }
        })
        .catch(() => Swal.fire("Error", "No se pudo eliminar.", "error"));
      }
    });
  };

  window.abrirIngresoRapido = function (producto_id, nombre) {
    const lbl = document.getElementById("ingreso_producto_label"); if (lbl) lbl.textContent = nombre || '';
    const hid = document.getElementById("ingreso_producto_id"); if (hid) hid.value = producto_id || '';
    $('#modalIngresoProducto').modal('show');
  };

  function limpiarFormulario() {
    const form = document.getElementById("formProducto");
    if (form) form.reset();
    setValue("producto_id", "");
    setValue("imagen_actual", "");
    const preview = document.getElementById("preview_imagen"); if (preview) { preview.src = ''; preview.classList.add('d-none'); }
    const inputImagen = document.getElementById("imagen"); if (inputImagen) inputImagen.value = "";
    const video = document.getElementById("video"); if (video) video.classList.add("d-none");
  }
})();
