// assets/js/main.js

document.addEventListener("DOMContentLoaded", function () {
  const iconSidenav = document.getElementById('iconSidenav');
  const body = document.querySelector('body');
  const sidenav = document.getElementById('sidenav-main');

  // Abrir/Cerrar menú lateral
  if (iconSidenav && sidenav) {
    iconSidenav.addEventListener('click', () => {
      if (body.classList.contains('g-sidenav-pinned')) {
        body.classList.remove('g-sidenav-pinned');
        sidenav.classList.remove('bg-white');
      } else {
        body.classList.add('g-sidenav-pinned');
        sidenav.classList.add('bg-white');
      }
    });
  }

  // Tooltips Bootstrap
  const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
  tooltipTriggerList.map(function (el) {
    return new bootstrap.Tooltip(el);
  });

  // Ocultar alertas flotantes después de 4 segundos
  const alertas = document.querySelectorAll('.alert');
  alertas.forEach(alerta => {
    setTimeout(() => {
      alerta.style.opacity = '0';
      setTimeout(() => alerta.remove(), 500);
    }, 4000);
  });

  // Resaltar menú activo en sidebar
  const navLinks = document.querySelectorAll('.nav-link');
  const currentPath = window.location.pathname;

  navLinks.forEach(link => {
    if (link.href.includes(currentPath.split('/').pop())) {
      link.classList.add('active', 'bg-gradient-primary');
    } else {
      link.classList.remove('active', 'bg-gradient-primary');
    }
  });

  // Soporte básico para modales dinámicos (opcional)
  const modalTriggers = document.querySelectorAll('[data-toggle="modal"]');
  modalTriggers.forEach(btn => {
    btn.addEventListener('click', function () {
      const targetModal = document.querySelector(this.getAttribute('data-target'));
      if (targetModal) {
        const modal = new bootstrap.Modal(targetModal);
        modal.show();
      }
    });
  });
});
