document.addEventListener('DOMContentLoaded', () => {
  const formulario = document.getElementById('form_movimiento');
  const inputCodigo = document.getElementById('codigo_producto');
  const tipoMovimiento = document.getElementById('tipo_movimiento');
  const cantidad = document.getElementById('cantidad');
  const motivo = document.getElementById('motivo');

  const btnEscanear = document.getElementById('btn_escanear');
  const contenedorQR = document.getElementById('contenedor_qr');
  const video = document.getElementById('video_qr');
  const btnDetenerQR = document.getElementById('btn_detener_qr');

  let qrScanner;

  btnEscanear.addEventListener('click', async () => {
    contenedorQR.style.display = 'block';
    qrScanner = new QrScanner(video, result => {
      inputCodigo.value = result;
      qrScanner.stop();
      contenedorQR.style.display = 'none';
    });
    await qrScanner.start();
  });

  btnDetenerQR.addEventListener('click', () => {
    if (qrScanner) {
      qrScanner.stop();
      contenedorQR.style.display = 'none';
    }
  });

  formulario.addEventListener('submit', function (e) {
    e.preventDefault();

    if (!inputCodigo.value || !tipoMovimiento.value || !cantidad.value) {
      alert("Complete todos los campos obligatorios.");
      return;
    }

    const datos = new FormData();
    datos.append('codigo', inputCodigo.value.trim());
    datos.append('tipo', tipoMovimiento.value);
    datos.append('cantidad', cantidad.value);
    datos.append('motivo', motivo.value.trim());
    datos.append('accion', 'registrar_movimiento');

    fetch('ajax/entradas_salidas.ajax.php', {
      method: 'POST',
      body: datos
    })
    .then(res => res.json())
    .then(resp => {
      if (resp.status === 'ok') {
        alert("Movimiento registrado correctamente.");
        formulario.reset();
      } else {
        alert("Error: " + resp.mensaje);
      }
    })
    .catch(error => {
      console.error('Error al enviar:', error);
      alert("Error en la solicitud.");
    });
  });
});
