<?php
require_once '../config/conexion.php';

/* Cabeceras + TZ */
header('Content-Type: application/json; charset=utf-8');
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");
header("Expires: 0");

date_default_timezone_set('America/Lima');
if (isset($conexion) && $conexion instanceof mysqli) {
  @mysqli_set_charset($conexion, 'utf8');
  @mysqli_query($conexion, "SET time_zone = '-05:00'");
}

$accion = $_GET['accion'] ?? '';
$categoria_id = isset($_GET['categoria_id']) && $_GET['categoria_id'] !== '' ? (int) $_GET['categoria_id'] : null;

if ($accion === 'obtener') {
  $tipos = [];

  if ($categoria_id) {
    $sql = "SELECT t.id, t.nombre, t.categoria_id, c.nombre AS categoria_nombre
            FROM tipos t
            LEFT JOIN categorias c ON c.id = t.categoria_id
            WHERE t.categoria_id = ?
            ORDER BY t.nombre ASC";
    $stmt = $conexion->prepare($sql);
    $stmt->bind_param("i", $categoria_id);
    $stmt->execute();
    $stmt->store_result();
    $stmt->bind_result($id, $nombre, $cat_id, $cat_nom);
    while ($stmt->fetch()) {
      $tipos[] = ['id'=>$id,'nombre'=>$nombre,'categoria_id'=>$cat_id,'categoria_nombre'=>$cat_nom];
    }
    $stmt->free_result();
    $stmt->close();
  } else {
    $sql = "SELECT t.id, t.nombre, t.categoria_id, c.nombre AS categoria_nombre
            FROM tipos t
            LEFT JOIN categorias c ON c.id = t.categoria_id
            ORDER BY t.nombre ASC";
    $res = $conexion->query($sql);
    while ($row = $res->fetch_assoc()) { $tipos[] = $row; }
  }

  echo json_encode($tipos, JSON_UNESCAPED_UNICODE);
  exit;
}

echo json_encode([], JSON_UNESCAPED_UNICODE);
