<?php
require_once "../controllers/productos.controlador.php";
require_once "../models/productos.modelo.php";

if ($_POST['accion'] === 'registrar_movimiento') {
    $codigo = $_POST['codigo'];
    $tipo = $_POST['tipo'];
    $cantidad = intval($_POST['cantidad']);
    $motivo = $_POST['motivo'] ?? '';

    if (empty($codigo) || empty($tipo) || $cantidad <= 0) {
        echo json_encode(['status' => 'error', 'mensaje' => 'Datos incompletos']);
        exit;
    }

    // Buscar producto por código
    $producto = ProductosControlador::ctrMostrarProductoPorCodigo($codigo);

    if (!$producto) {
        echo json_encode(['status' => 'error', 'mensaje' => 'Producto no encontrado']);
        exit;
    }

    $nuevoStock = ($tipo === 'entrada') ? $producto['stock'] + $cantidad : $producto['stock'] - $cantidad;

    if ($nuevoStock < 0) {
        echo json_encode(['status' => 'error', 'mensaje' => 'Stock insuficiente para salida']);
        exit;
    }

    // Actualizar stock
    $actualizado = ProductosControlador::ctrActualizarStock($producto['id'], $nuevoStock);

    if ($actualizado) {
        // Registrar movimiento en tabla adicional si se desea
        // (Ejemplo opcional, solo si has creado tabla movimientos)
        echo json_encode(['status' => 'ok']);
    } else {
        echo json_encode(['status' => 'error', 'mensaje' => 'No se pudo actualizar stock']);
    }
}
